#ifndef AUDIO_HAL_H_
#define AUDIO_HAL_H_


#define AUDIO_DAC_LFIFO_PORT     0
#define AUDIO_DAC_RFIFO_PORT     1
#define AUDIO_ADC_LFIFO_PORT     2
#define AUDIO_ADC_RFIFO_PORT     3
#define AUDIO_CMD_PORT           4
#define AUDIO_STATUS_PORT        5

#define MASK_STATUS_DAC_FULL    0x01
#define MASK_STATUS_ADC_EMPTY   0x02

#define IOWR_AUDIO(index, data16)    IOWR(AUDIO_BASE, index, data16)
#define IORD_AUDIO(index)            IORD(AUDIO_BASE, index)

#define AUDIO_DAC_FULL()          ((IORD_AUDIO(AUDIO_STATUS_PORT) & MASK_STATUS_DAC_FULL)?TRUE:FALSE)     
#define AUDIO_DAC_WRITE_L(data16) IOWR_AUDIO(AUDIO_DAC_LFIFO_PORT, data16)     
#define AUDIO_DAC_WRITE_R(data16) IOWR_AUDIO(AUDIO_DAC_RFIFO_PORT, data16)
#define AUDIO_ADC_EMPTY()         ((IORD_AUDIO(AUDIO_STATUS_PORT) & MASK_STATUS_ADC_EMPTY)?TRUE:FALSE)     
#define AUDIO_ADC_READ_L()        IORD_AUDIO(AUDIO_ADC_LFIFO_PORT)
#define AUDIO_ADC_READ_R()        IORD_AUDIO(AUDIO_ADC_RFIFO_PORT)
#define AUDIO_ADC_READ()          ((((IORD_AUDIO(AUDIO_ADC_LFIFO_PORT) << 16) & 0xFFFF0000) | (IORD_AUDIO(AUDIO_ADC_RFIFO_PORT) & 0xFFFF)))
#define AUDIO_FIFO_CLEAR()        IOWR_AUDIO(AUDIO_CMD_PORT, 0x01)


#endif /*AUDIO_HAL_H_*/
